-- Name: BSU_closeCoverEvent
-- Author: Chissel

BSU_closeCoverEvent = {}

local BSU_closeCoverEvent_mt = Class(BSU_closeCoverEvent, Event)
InitEventClass(BSU_closeCoverEvent, "BSU_closeCoverEvent")

function BSU_closeCoverEvent.emptyNew()
	local self = Event.new(BSU_closeCoverEvent_mt)

	return self
end

function BSU_closeCoverEvent.new(bunkerSilo, closeAtFront)
	local self = BSU_closeCoverEvent.emptyNew()
	self.bunkerSilo = bunkerSilo
    self.closeAtFront = closeAtFront

	return self
end

function BSU_closeCoverEvent:readStream(streamId, connection)
    self.bunkerSilo = NetworkUtil.readNodeObject(streamId)
    self.closeAtFront = streamReadBool(streamId)

	self:run(connection)
end

function BSU_closeCoverEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.bunkerSilo)
    streamWriteBool(streamId, self.closeAtFront)
end

function BSU_closeCoverEvent:run(connection)
    self.bunkerSilo:closeCover(self.closeAtFront)

	if not connection:getIsServer() then
        g_server:broadcastEvent(BSU_closeCoverEvent.new(self.bunkerSilo, self.closeAtFront), false)
	end
end