-- Name: BSU_reopenCoverEvent
-- Author: Chissel

BSU_reopenCoverEvent = {}

local BSU_reopenCoverEvent_mt = Class(BSU_reopenCoverEvent, Event)
InitEventClass(BSU_reopenCoverEvent, "BSU_reopenCoverEvent")

function BSU_reopenCoverEvent.emptyNew()
	local self = Event.new(BSU_reopenCoverEvent_mt)

	return self
end

function BSU_reopenCoverEvent.new(bunkerSilo)
	local self = BSU_reopenCoverEvent.emptyNew()
	self.bunkerSilo = bunkerSilo

	return self
end

function BSU_reopenCoverEvent:readStream(streamId, connection)
    self.bunkerSilo = NetworkUtil.readNodeObject(streamId)

    self:run(connection)
end

function BSU_reopenCoverEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.bunkerSilo)
end

function BSU_reopenCoverEvent:run(connection)
	if not connection:getIsServer() then
		self.bunkerSilo:reopenCover()
	end
end