--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 09.10.2022
Revision: FS25-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

MoveAnimalsScreen = {}
MoveAnimalsScreen.INSTANCE = nil

MoveAnimalsScreen.MOD_NAME = g_currentModName
MoveAnimalsScreen.MOD_DIR = g_currentModDirectory

MoveAnimalsScreen.SELECTION_NONE = 0
MoveAnimalsScreen.SELECTION_TARGET = 1
MoveAnimalsScreen.SELECTION_SOURCE = 2
MoveAnimalsScreen.SELECTION_AMOUNT = 3

MoveAnimalsScreen.INPUT_CONTEXT = "MoveAnimalsScreen"

MoveAnimalsScreen.DEFUALT_NUM_ANIMALS_TEXT = {"0"}
MoveAnimalsScreen.MAX_NUM_ANIMALS_TO_MOVE = 250

local MoveAnimalsScreen_mt = Class(MoveAnimalsScreen, ScreenElement)

function MoveAnimalsScreen.show(husbandry)
    if g_moveHusbandryAnimals == nil then
        InfoDialog.show(string.format("%s\n\nPlease report errors via the Farming Simulator Official forums.\nhttps://forum.giants-software.com", g_i18n:getText("warning_actionNotAllowedNow")), nil, nil, DialogElement.TYPE_WARNING)

        return
    end

    if MoveAnimalsScreen.INSTANCE == nil then
        MoveAnimalsScreen.register()
    end

    MoveAnimalsScreen.INSTANCE:setHusbandry(husbandry)

    g_gui:showGui("MoveAnimalsScreen")
end

function MoveAnimalsScreen.register()
    local instance = MoveAnimalsScreen.new()

    g_gui:loadGui(MoveAnimalsScreen.MOD_DIR .. "gui/MoveAnimalsScreen.xml", "MoveAnimalsScreen", instance)
    MoveAnimalsScreen.INSTANCE = instance

    return instance
end

function MoveAnimalsScreen.new(custom_mt)
    local self = ScreenElement.new(nil, custom_mt or MoveAnimalsScreen_mt)

    self.isOpen = false

    self.selectionState = MoveAnimalsScreen.SELECTION_NONE
    self.isUpdatingList = false

    self.husbandry = nil
    self.husbandries = {}

    self.transportCost = 0

    return self
end

function MoveAnimalsScreen.createFromExistingGui(gui, guiName)
    local husbandry = gui.husbandry

    MoveAnimalsScreen.register()

    if husbandry ~= nil then
        MoveAnimalsScreen.show(husbandry)
    end

    return MoveAnimalsScreen.INSTANCE
end

function MoveAnimalsScreen:onGuiSetupFinished()
    MoveAnimalsScreen:superClass().onGuiSetupFinished(self)

    self.numAnimalsElement:setTexts(MoveAnimalsScreen.DEFUALT_NUM_ANIMALS_TEXT)

    FocusManager:linkElements(self.targetSelector, FocusManager.TOP, self.targetSlider)
    FocusManager:linkElements(self.targetSelector, FocusManager.BOTTOM, self.targetSlider)

    FocusManager:linkElements(self.targetSlider, FocusManager.TOP, self.targetSelector)
    FocusManager:linkElements(self.targetSlider, FocusManager.BOTTOM, self.targetSelector)
    FocusManager:linkElements(self.targetSlider, FocusManager.RIGHT, self.targetSelector)
    FocusManager:linkElements(self.targetSlider, FocusManager.LEFT, self.targetSelector)

    FocusManager:linkElements(self.sourceList, FocusManager.TOP, nil)
    FocusManager:linkElements(self.sourceList, FocusManager.BOTTOM, nil)
    FocusManager:linkElements(self.sourceList, FocusManager.RIGHT, nil)
    FocusManager:linkElements(self.sourceList, FocusManager.LEFT, nil)

    FocusManager:linkElements(self.numAnimalsElement, FocusManager.TOP, nil)
    FocusManager:linkElements(self.numAnimalsElement, FocusManager.BOTTOM, nil)
end

function MoveAnimalsScreen:onOpen()
    MoveAnimalsScreen:superClass().onOpen(self)

    if self.ingameMapElement ~= nil then
        self.ingameMapBase = g_currentMission.hud:getIngameMap()
        self.ingameMapElement:setIngameMap(self.ingameMapBase)

        self.mapHotspotFilterStates = {}

        for category, state in pairs(self.ingameMapBase.filter) do
            self.mapHotspotFilterStates[category] = state
            self.ingameMapBase:setHotspotFilter(category, false)
        end

        self.ingameMapElement:onOpen()
    end

    self.isOpen = true

    g_gameStateManager:setGameState(GameState.MENU_ANIMAL_SHOP) -- Use the same state as Animal Screen, for now this is mainly used by SoundMixer.

    self.isUpdatingList = false
    self:updateScreen(false)

    self:setSelectionState(MoveAnimalsScreen.SELECTION_TARGET)
    self:onMoneyChanged()

    g_messageCenter:subscribe(MessageType.MONEY_CHANGED, self.onMoneyChanged, self)
    g_messageCenter:subscribe(MessageType.MOVE_HUSBANDRY_ANIMALS_SETTINGS_CHANGED, self.updateTransportBox, self)

    self:toggleCustomInputContext(true, MoveAnimalsScreen.INPUT_CONTEXT)
    g_inputBinding:registerActionEvent(InputAction.AXIS_MTO_SCROLL, self, self.onInputScroll, false, false, true, true)
end

function MoveAnimalsScreen:onClose()
    MoveAnimalsScreen:superClass().onClose(self)

    if self.ingameMapElement ~= nil then
        self.ingameMapElement:onClose()

        if self.mapHotspotFilterStates ~= nil then
            if self.ingameMapBase ~= nil then
                for category, state in pairs(self.mapHotspotFilterStates) do
                    self.ingameMapBase:setHotspotFilter(category, state)
                end
            end

            self.mapHotspotFilterStates = nil
        end
    end

    self:toggleCustomInputContext(false, MoveAnimalsScreen.INPUT_CONTEXT)
    g_inputBinding:removeActionEventsByTarget(self)

    g_currentMission:resetGameState()
    g_messageCenter:unsubscribeAll(self)

    g_currentMission:showMoneyChange(MoneyType.OTHER)

    self.isOpen = false
    self:setHusbandry(nil)
end

function MoveAnimalsScreen:onDrawPostIngameMapHotspots()
    if self.husbandryHotspot ~= nil then
        self.ingameMapElement:drawHotspot(self.husbandryHotspot, false)
    end
end

function MoveAnimalsScreen:getCellTypeForItemInSection(list, section, index)
    if list == self.sourceList then
        local sourceItem = self.sourceItems[index]
        local lastSourceItem = self.sourceItems[index - 1]

        if lastSourceItem == nil or lastSourceItem:getSubTypeIndex() ~= sourceItem:getSubTypeIndex() then
            return "sectionCell"
        end

        return "defaultCell"
    end
end

function MoveAnimalsScreen:getNumberOfItemsInSection(list, section)
    if not self.isOpen then
        return 0
    end

    if list == self.sourceList then
        return #self.sourceItems
    end

    return #self.targetItems
end

function MoveAnimalsScreen:populateCellForItemInSection(list, section, index, cell)
    if list == self.sourceList then
        local item = self.sourceItems[index]

        local subType = g_currentMission.animalSystem:getSubTypeByIndex(item:getSubTypeIndex())
        self.isHorse = subType.typeIndex == AnimalType.HORSE

        if cell.name == "sectionCell" then
            cell:getAttribute("title"):setText(g_fillTypeManager:getFillTypeTitleByIndex(subType.fillTypeIndex))
        end

        cell:getAttribute("icon"):setImageFilename(item:getFilename())
        cell:getAttribute("name"):setText(item:getName())

        if self.isHorse then
            cell:getAttribute("amount"):setValue("")
        else
            cell:getAttribute("amount"):setText(item.cluster == nil and "" or ("x" .. item.cluster.numAnimals or ""))
        end
    elseif list == self.targetList then
        local item = self.targetItems[index]

        self.isHorse = g_currentMission.animalSystem:getSubTypeByIndex(item:getSubTypeIndex()).typeIndex == AnimalType.HORSE

        cell:getAttribute("icon"):setImageFilename(item:getFilename())
        cell:getAttribute("name"):setText(item:getName())
        cell:getAttribute("separator"):setVisible(index > 1)

        if self.isHorse then
            cell:getAttribute("amount"):setValue("")

            return
        end

        cell:getAttribute("amount"):setText(item.cluster == nil and "" or ("x" .. item.cluster.numAnimals or ""))
    end
end

function MoveAnimalsScreen:onListSelectionChanged(list, section, index)
    if list == self.sourceList then
        local cluster = self.sourceItems[index]
        local maxNumAnimals = math.min(cluster:getNumAnimals(), self.targetHusbandry ~= nil and self.targetHusbandry:getNumOfFreeAnimalSlots(cluster:getSubTypeIndex()) or 0)

        if maxNumAnimals > 0 then
            maxNumAnimals = math.min(maxNumAnimals, MoveAnimalsScreen.MAX_NUM_ANIMALS_TO_MOVE)

			local texts = table.create(maxNumAnimals + 1)

            for i = 0, maxNumAnimals do
                table.insert(texts, tostring(i))
            end

            self.numAnimalsElement:setTexts(texts)
        else
            self.numAnimalsElement:setTexts(MoveAnimalsScreen.DEFUALT_NUM_ANIMALS_TEXT)
        end

        self.numAnimalsElement:setState(1)

        self:updateInfoBox(cluster)
        self:updateTransportBox()
    end
end

function MoveAnimalsScreen:onClickTargetSelector(state, multiTextElement)
    self.targetItems = {}

    self.husbandryHotspot = nil
    self.distanceToTarget = 0

    local targetHusbandry = self.husbandriesInRange[state]
    local validTarget = targetHusbandry ~= nil

    if validTarget then
        local clusters = targetHusbandry:getClusters()

        if clusters ~= nil then
            for _, cluster in ipairs(clusters) do
                table.insert(self.targetItems, AnimalItemStock.new(cluster))
            end
        end

        if targetHusbandry.spec_hotspots ~= nil then
            for _, mapHotspot in ipairs (targetHusbandry.spec_hotspots.mapHotspots) do
                if self.husbandryHotspot == nil then
                    self.husbandryHotspot = mapHotspot
                end

                if mapHotspot:getCategory() == MapHotspot.CATEGORY_ANIMAL then
                    self.husbandryHotspot = mapHotspot

                    break
                end
            end
        end

        if self.husbandry ~= nil then
            self.distanceToTarget = calcDistanceFrom(self.husbandry.rootNode, targetHusbandry.rootNode)
        end

        self:updateMapPosition()
    end

    self.targetHusbandry = targetHusbandry

    self.targetList:reloadData()
    self.targetListEmptyText:setVisible(validTarget and #self.targetItems == 0)

    self.sourceList:setSelectedItem(1, self.sourceList.selectedIndex or 1, true) -- refresh number of animals.
    self:setSelectionState(MoveAnimalsScreen.SELECTION_TARGET)
end

function MoveAnimalsScreen:onClickSourceList()
    if self.selectionState ~= MoveAnimalsScreen.SELECTION_SOURCE then
        self:setSelectionState(MoveAnimalsScreen.SELECTION_SOURCE)
    end
end

function MoveAnimalsScreen:onClickNumAnimals(state, optionSlider)
    if self.selectionState ~= MoveAnimalsScreen.SELECTION_AMOUNT then
        self:setSelectionState(MoveAnimalsScreen.SELECTION_AMOUNT)
    else
        self:updateButtons()
    end

    self:updateTransportBox()
end

function MoveAnimalsScreen:onClickBack()
    MoveAnimalsScreen:superClass().onClickBack(self)

    if self.selectionState <= MoveAnimalsScreen.SELECTION_TARGET then
        self:changeScreen(nil)

        return
    end

    self:setSelectionState(self.selectionState - 1)
end

function MoveAnimalsScreen:onClickSelect()
    if self.selectionState < MoveAnimalsScreen.SELECTION_AMOUNT then
        self:setSelectionState(self.selectionState + 1)
    end

    return true -- suppress the sound as the selection has a sound already
end

function MoveAnimalsScreen:onClickMove()
    local numAnimals = self.numAnimalsElement:getState() - 1

    if numAnimals > 0 and self.selectionState == MoveAnimalsScreen.SELECTION_AMOUNT then
        local sourceHusbandry = self.husbandry
        local targetHusbandry = self.targetHusbandry

        local selectedIndex = self.sourceList.selectedIndex
        local item = self.sourceItems[selectedIndex]

        if targetHusbandry ~= nil and item ~= nil and sourceHusbandry ~= nil then
            local animalType = string.format("%s, %s", item:getTitle(), item:getName())
            local text = ""

            if numAnimals > 1 then
                text = string.namedFormat(g_i18n:getText("shop_doYouWantToMoveAnimalsToFarm"), "numAnimals", numAnimals, "animalType", animalType)
            else
                text = string.namedFormat(g_i18n:getText("shop_doYouWantToMoveAnimalsToFarmSingular"), "numAnimals", numAnimals, "animalType", animalType)
            end

            self.transportCost = g_moveHusbandryAnimals:getTransportCosts(numAnimals, self.distanceToTarget) or 0

            local function callback(confirmed)
                if confirmed then
                    local clusterId = item:getClusterId()
                    local errorCode = MoveAnimalsEvent.validate(sourceHusbandry, targetHusbandry, clusterId, numAnimals, self.transportCost, sourceHusbandry:getOwnerFarmId())

                    if errorCode ~= MoveAnimalsEvent.SUCCESS then
                        self.transportCost = 0
                        InfoDialog.show(MoveAnimalsEvent.getErrorCodeText(errorCode), nil, nil, DialogElement.TYPE_WARNING)

                        return false
                    end

                    MessageDialog.show(g_i18n:getText("shop_moveToFarm"))

                    g_messageCenter:subscribe(MoveAnimalsEvent, self.onAnimalMoved, self)
                    g_client:getServerConnection():sendEvent(MoveAnimalsEvent.new(self.husbandry, self.targetHusbandry, clusterId, numAnimals, self.transportCost))
                else
                    self.transportCost = 0
                end
            end

            YesNoDialog.show(callback, nil, string.format("%s\n\n%s > %s", text, sourceHusbandry:getName(), targetHusbandry:getName()), g_i18n:getText("ui_attention"), g_i18n:getText("button_confirm"), g_i18n:getText("button_cancel"))

            return false
        end
    end

    return true
end

function MoveAnimalsScreen:onAnimalMoved(errorCode)
    g_messageCenter:unsubscribe(MoveAnimalsEvent, self)

    MessageDialog.hide()

    local errorText, success = MoveAnimalsEvent.getErrorCodeText(errorCode)

    if not string.isNilOrWhitespace(errorText) then
        InfoDialog.show(errorText, self.updateScreen, self, DialogElement[success and "TYPE_INFO" or "TYPE_WARNING"], nil, nil, true)
    end

    self.transportCost = 0
end

function MoveAnimalsScreen:onFocusTargetSelection(multiTextElement)
    if self.selectionState ~= MoveAnimalsScreen.SELECTION_TARGET then
        self:setSelectionState(MoveAnimalsScreen.SELECTION_TARGET)
    end
end

function MoveAnimalsScreen:onFocusNumAnimals(multiTextElement)
    if self.selectionState ~= MoveAnimalsScreen.SELECTION_AMOUNT then
        self:setSelectionState(MoveAnimalsScreen.SELECTION_AMOUNT)
    end
end

function MoveAnimalsScreen:onLeaveNumAnimals(multiTextElement)
    multiTextElement:setState(1) -- Reset to 0
end

function MoveAnimalsScreen:onMoneyChanged()
    if g_localPlayer ~= nil then
        local farm = g_farmManager:getFarmById(g_localPlayer.farmId)

        self.currentBalanceText:applyProfile(farm.money <= -1 and ShopMenu.GUI_PROFILE.SHOP_MONEY_NEGATIVE or ShopMenu.GUI_PROFILE.SHOP_MONEY, nil, true)
        self.currentBalanceText:setText(g_i18n:formatMoney(farm.money, 0, true, false))

        if self.currentBalanceBox ~= nil then
            self.currentBalanceBox:invalidateLayout()
            self.currentBalanceBoxBg:setSize(self.currentBalanceBox.flowSizes[1] + 60 * g_pixelSizeScaledX)
        end
    end
end

function MoveAnimalsScreen:setHusbandry(husbandry)
    self.husbandry = husbandry

    if self.isOpen then
        self:updateScreen(false)
    end
end

function MoveAnimalsScreen:setSelectionState(state, forceUpdate)
    local hasTargets = #self.targetSelector.texts > 0
    local hasItems = self.sourceList:getItemCount() > 0

    if state ~= self.selectionState or forceUpdate then
        local targetState = state == MoveAnimalsScreen.SELECTION_TARGET
        local sourceState = state == MoveAnimalsScreen.SELECTION_SOURCE
        local amountState = state == MoveAnimalsScreen.SELECTION_AMOUNT

        if sourceState then
            if not hasItems then
                self:setSelectionState(MoveAnimalsScreen.SELECTION_TARGET)

                return
            end
        elseif amountState then
            if not hasItems or #self.numAnimalsElement.texts <= 0 then
                self:setSelectionState(MoveAnimalsScreen.SELECTION_TARGET)

                return
            end
        end

        self.targetBoxBg:setSelected(targetState, true) -- do not update children
        self.targetBoxArrow:setSelected(targetState, true) -- do not update children
        self.sourceBoxBg:setSelected(sourceState)
        self.numAnimalsBoxBg:setSelected(amountState)

        if sourceState then
            FocusManager:setFocus(self.sourceList)
        elseif targetState then
            FocusManager:setFocus(self.targetSelector)
        else
            FocusManager:setFocus(self.numAnimalsElement)
        end

        self.selectionState = state
    end

    if not hasTargets then
        self.statusText:setText(g_i18n:getText("ui_noHusbandriesPlaced"))

        self.statusText:setVisible(true)
        self.contentContainer:setVisible(false)
    elseif not hasItems then
        self.statusText:setText(g_i18n:getText("ui_noAnimalsInHusbandry"))

        self.statusText:setVisible(true)
        self.contentContainer:setVisible(false)
    elseif #self.numAnimalsElement.texts == 1 then
        self.statusText:setText(g_i18n:getText("animals_husbandryIsFull"))

        self.statusText:setVisible(true)
        self.contentContainer:setVisible(false)
    else
        self.statusText:setVisible(false)
        self.contentContainer:setVisible(true)
    end

    self.targetContainer:setVisible(hasTargets)

    self:updateButtons()
end

function MoveAnimalsScreen:updateHusbandryData()
    self.husbandriesInRange = {}

    self.sourceItems = {}
    self.targetItems = {}

    if self.husbandry ~= nil then
        local sourceHusbandry =  self.husbandry
        local farmId = sourceHusbandry:getOwnerFarmId()
        local animalTypeIndex = sourceHusbandry:getAnimalTypeIndex()

        for _, husbandry in ipairs(g_currentMission.husbandrySystem.placeables) do
            if husbandry ~= sourceHusbandry and husbandry:getOwnerFarmId() == farmId then
                if animalTypeIndex == husbandry:getAnimalTypeIndex() then
                    table.insert(self.husbandriesInRange, husbandry)
                end
            end
        end

        local clusters = sourceHusbandry:getClusters()

        if clusters ~= nil then
            for _, cluster in ipairs(clusters) do
                table.insert(self.sourceItems, AnimalItemStock.new(cluster))
            end
        end
    else

    end

    self.sourceList:reloadData(true)
end

function MoveAnimalsScreen:updateMapPosition(husbandry)
    if self.isOpen and self.ingameMapElement ~= nil then
        local worldPosX, worldPosZ = nil, nil
        local width, height = 650, 650

        if self.husbandryHotspot ~= nil then
            worldPosX, worldPosZ = self.husbandryHotspot:getWorldPosition()
        elseif husbandry ~= nil then
            local _ = nil
            worldPosX, _, worldPosZ = husbandry:getPosition()
        end

        if worldPosX ~= nil then
            self.ingameMapElement:fitToBoundary(worldPosX - width * 0.5, worldPosX + width * 0.5, worldPosZ - height * 0.5, worldPosZ + height * 0.5, 0.1)
            self.ingameMapElement:setCenterToWorldPosition(worldPosX, worldPosZ)
        end
    end
end

function MoveAnimalsScreen:updateButtons()
    local buttonsVisible = self.sourceList:getItemCount() > 0 and self.targetContainer:getIsVisible() and self.numAnimalsElement:getIsVisible()
    local buttonMoveVisible = buttonsVisible and self.selectionState == MoveAnimalsScreen.SELECTION_AMOUNT and self.numAnimalsElement:getState() > 1
    local buttonSelectVisible = buttonsVisible and self.selectionState ~= MoveAnimalsScreen.SELECTION_AMOUNT

    if buttonMoveVisible ~= self.buttonMove:getIsVisible() or buttonSelectVisible ~= self.buttonSelect:getIsVisible() then
        self.buttonMove:setVisible(buttonMoveVisible)
        self.buttonSelect:setVisible(buttonSelectVisible)

        self.buttonsPanel:invalidateLayout()
    end
end

function MoveAnimalsScreen:updateScreen(animalsMoved)
    self.isUpdatingList = true
    self:updateHusbandryData()
    self.isUpdatingList = false

    local texts = {}
    local hasTargets = #self.husbandriesInRange > 0

    local targetHusbandry = self.targetHusbandry
    local targetState = 1

    if hasTargets then
        for _, husbandry in pairs(self.husbandriesInRange) do
            local animalType = g_currentMission.animalSystem:getTypeByIndex(self.husbandry:getAnimalTypeIndex())
            local numAnimalsText = " (" .. husbandry:getNumOfAnimals() .. "/" .. husbandry:getMaxNumOfAnimals(animalType) .. ")"

            table.insert(texts, husbandry:getName() .. numAnimalsText)

            if targetHusbandry == husbandry then
                targetState = #texts
            end
        end
    end

    self.targetSelector:setTexts(texts)

    if not animalsMoved then
        targetState = 1
    end

    if hasTargets then
        self.targetSelector:setState(targetState)
    end

    self:onClickTargetSelector(targetState, self.targetSelector, false)
    -- self:setSelectionState(MoveAnimalsScreen.SELECTION_TARGET)

    if hasTargets and self.sourceList:getItemCount() > 0 then
        if animalsMoved then
            self.sourceList:setSelectedIndex(1, 1)
        end

        self:updateInfoBox()
        self:updateTransportBox()
    end
end

function MoveAnimalsScreen:updateInfoBox(item)
    if item == nil then
        item = self.sourceItems[self.sourceList.selectedIndex]
    end

    self.infoIcon:setVisible(item ~= nil)
    self.infoName:setVisible(item ~= nil)

    if item ~= nil then
        self.infoIcon:setImageFilename(item:getFilename())

        local subType = g_currentMission.animalSystem:getSubTypeByIndex(item:getSubTypeIndex())
        local fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(subType.fillTypeIndex)

        self.infoName:setText(fillTypeTitle)

        local infos = item:getInfos()

        for k, infoTitle in ipairs(self.infoTitle) do
            local info = infos[k]
            local infoValue = self.infoValue[k]

            infoTitle:setVisible(info ~= nil)
            infoValue:setVisible(info ~= nil)

            if info ~= nil then
                infoTitle:setText(infos[k].title)
                infoValue:setText(infos[k].value)
            end
        end
    end
end

function MoveAnimalsScreen:updateTransportBox()
    local distanceFormated = "-"
    local transportFeeFormated = "-"
    local totalCostFormated = "-"

    if self.distanceToTarget > 1 then
        local useFahrenheit = g_i18n.useFahrenheit
        local distanceText = " " .. g_i18n:getText(useFahrenheit and "unit_ftShort" or "unit_mShort")

        distanceFormated = MathUtil.round(useFahrenheit and self.distanceToTarget * 3.28084 or self.distanceToTarget, 0) .. distanceText

        local numAnimals = self.numAnimalsElement:getState() - 1
        local transportCost, transportFee, requiresTransport = g_moveHusbandryAnimals:getTransportCosts(numAnimals, self.distanceToTarget)

        if requiresTransport and transportFee > 0 then
            transportFeeFormated = g_i18n:formatMoney(transportFee, 0, true, false)

            if transportCost > 0 then
                totalCostFormated = g_i18n:formatMoney(transportCost, 0, true, false)
            end
        end
    end

    self.infoDistance:setValue(distanceFormated)
    self.infoFee:setValue(transportFeeFormated)
    self.infoTotal:setValue(totalCostFormated)
end

function MoveAnimalsScreen:onInputScroll(_, inputValue)
    if inputValue ~= 0 and self.selectionState == MoveAnimalsScreen.SELECTION_AMOUNT then
        self.numAnimalsElement:setState(self.numAnimalsElement:getState() + inputValue, true)
    end
end
